unit fmSettings;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TSettings = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    edComponentName: TEdit;
    Label2: TLabel;
    edUnitName: TEdit;
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Dclarations prives }
    FComponentName : String;
    FUnitName : String;
  public
    { Dclarations publiques }
    procedure LoadFromStream( S : TStream );
    procedure SaveToStream( S : TStream );
  end;

var
  Settings: TSettings;

implementation
uses unMisc, fmMain;
{$R *.DFM}

procedure TSettings.LoadFromStream( S : TStream );
begin
  edComponentName.Text := ReadString( S );
  edUnitName.Text := ReadString( S );
end;

procedure TSettings.SaveToStream( S : TStream );
begin
  WriteString( S, edComponentName.Text );
  WriteString( S, edUnitName.Text );
end;


procedure TSettings.FormShow(Sender: TObject);
begin
  FComponentName := edComponentName.Text;
  FUnitName := edUnitName.Text;
end;

procedure TSettings.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if ModalResult = mrOk then
    MainForm.FChanged := True
  else
    begin
      edComponentName.Text := FComponentName;
      edUnitName.Text := FUnitName;
    end;
end;

end.
